/*
 * Decompiled with CFR 0.152.
 */
package PopupNavigator;

import PopupNavigator.PopupNavigatorMenu;
import PopupNavigator.PopupNavigatorMenuItem;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class PopupNavigatorApplet
extends Applet {
    private boolean mouseIn = false;
    private boolean mouseDown = false;
    private static final short MaxSubParameters = 9;
    private static final short MaxMenuDepth = 10;
    private char delimiterChar = (char)59;
    private char escapeChar = (char)92;
    private String URLBase = "CODEBASE";
    private String defaultFontName = "Dialog";
    private String defaultFontStyle = "PLAIN";
    private String defaultFontSize = "12";
    private String defaultForegroundColor = "BLACK";
    private String defaultBackgroundColor = "LIGHTGRAY";
    private String defaultFrame = null;
    private static final String smRecursive = "RECURSIVE";
    private static final String smItem = "ITEM";
    private static final String smNone = "NONE";
    private String selectionMode = "RECURSIVE";
    private String selectionFontName = null;
    private String selectionFontStyle = "BOLD";
    private String selectionFontSize = null;
    private String menuActivation = "CLICK";
    private String statusText = null;
    private String menuPosition = "BOTTOM";
    private String missingURL = "ERROR";
    private String labelText = null;
    private Font labelFont = null;
    private Color labelForeground = null;
    private Color labelBackground = null;
    private String mouseoverLabelText = null;
    private Font mouseoverLabelFont = null;
    private Color mouseoverLabelForeground = null;
    private Color mouseoverLabelBackground = null;
    private String clickLabelText = null;
    private Font clickLabelFont = null;
    private Color clickLabelForeground = null;
    private Color clickLabelBackground = null;
    private static final String bsFlat = "FLAT";
    private static final String bsSemiflat = "SEMIFLAT";
    private static final String bsNormal = "NORMAL";
    private static final String bhHover = "HOVER";
    private static final String bhNohover = "NOHOVER";
    private String buttonStyle = "NORMAL";
    private String buttonHover = "HOVER";
    private Image buttonImage = null;
    private Image mouseoverButtonImage = null;
    private Image clickButtonImage = null;
    private static final String bipAbsolute = "ABSOLUTE";
    private static final String bipCenter = "CENTER";
    private static final String bipLeft = "LEFT";
    private static final String bipRight = "RIGHT";
    private static final String bipTop = "TOP";
    private static final String bipBottom = "BOTTOM";
    private String buttonImagePosition = "ABSOLUTE";
    private String buttonImagePositionX = "0";
    private String buttonImagePositionY = "0";
    private String mouseoverButtonImagePosition = null;
    private String mouseoverButtonImagePositionX = null;
    private String mouseoverButtonImagePositionY = null;
    private String clickButtonImagePosition = null;
    private String clickButtonImagePositionX = null;
    private String clickButtonImagePositionY = null;
    PopupNavigatorMenuItem oldSelection = null;
    short[] paramCoord = new short[10];
    boolean isStandalone = false;
    GridLayout gridLayout1 = new GridLayout();
    PopupMenu popupMenu = new PopupMenu();

    public String getParameter(String string, String string2) {
        String string3;
        String string4 = string3 = this.isStandalone ? System.getProperty(string, string2) : this.getParameter(string);
        if (string3 == null) {
            string3 = string2;
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        return string3;
    }

    private Image getImageFromParam(String string, Image image) {
        String string2 = this.getParameter(string, null);
        if (string2 == null) {
            return image;
        }
        if (string2.length() == 0) {
            return null;
        }
        return this.getImage(this.encodeURL(string2));
    }

    private boolean isCurrentDomain(String string) {
        String string2 = string.trim();
        if (string2.startsWith("mailto:")) {
            return false;
        }
        int n = string2.indexOf("://");
        if (n >= 0) {
            URL uRL = this.getDocumentBase();
            String string3 = uRL.getProtocol();
            string3 = string3.equalsIgnoreCase("mailto") ? "mailto:" : String.valueOf(string3).concat(String.valueOf("://"));
            String string4 = uRL.getHost();
            return string2.toLowerCase().startsWith(String.valueOf(string3).concat(String.valueOf(string4)).toLowerCase());
        }
        return true;
    }

    private URL encodeURL(String string) {
        try {
            URL uRL = this.URLBase.equalsIgnoreCase("CODEBASE") ? this.getCodeBase() : (this.URLBase.equalsIgnoreCase("DOCUMENT") ? this.getDocumentBase() : new URL(this.URLBase));
            URL uRL2 = new URL(uRL, string);
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL = null;
            return uRL;
        }
    }

    private String[] decodeParamValue(String string, String[] stringArray) throws Exception {
        String[] stringArray2 = new String[9];
        if (stringArray != null && stringArray.length > 9) {
            throw new Exception("PopupNavigatorApplet.decodeParamValue() Defaults out of range.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == this.escapeChar) {
                if (++i >= string.length()) continue;
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (string.charAt(i) == this.delimiterChar) {
                if (stringBuffer.length() > 0) {
                    stringArray2[n] = stringBuffer.toString();
                    stringBuffer = new StringBuffer();
                } else if (stringArray != null && n < stringArray.length) {
                    stringArray2[n] = stringArray[n];
                }
                ++n;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (stringBuffer.length() > 0) {
            stringArray2[n++] = stringBuffer.toString();
        } else if (stringArray != null && n < stringArray.length) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        if (stringArray != null) {
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
        }
        return stringArray2;
    }

    private int strToFontStyle(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("BOLD")) {
            return 1;
        }
        if (string2.equals("ITALIC")) {
            return 2;
        }
        if (string2.equals("BOLDITALIC") || string2.equals("ITALICBOLD")) {
            return 3;
        }
        return 0;
    }

    private Color strToColor(String string) throws Exception {
        Color color = null;
        if (Character.isLetter(string.charAt(0))) {
            String string2 = string.trim().toUpperCase();
            if (string2.equals("BLACK")) {
                color = Color.black;
            } else if (string2.equals("BLUE")) {
                color = Color.blue;
            } else if (string2.equals("CYAN")) {
                color = Color.cyan;
            } else if (string2.equals("DARKGRAY")) {
                color = Color.darkGray;
            } else if (string2.equals("GRAY")) {
                color = Color.gray;
            } else if (string2.equals("GREEN")) {
                color = Color.green;
            } else if (string2.equals("LIGHTGRAY")) {
                color = Color.lightGray;
            } else if (string2.equals("MAGENTA")) {
                color = Color.magenta;
            } else if (string2.equals("ORANGE")) {
                color = Color.orange;
            } else if (string2.equals("PINK")) {
                color = Color.pink;
            } else if (string2.equals("RED")) {
                color = Color.red;
            } else if (string2.equals("WHITE")) {
                color = Color.white;
            } else if (string2.equals("YELLOW")) {
                color = Color.yellow;
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            Integer n = null;
            Integer n2 = null;
            Integer n3 = null;
            if (stringTokenizer.hasMoreTokens()) {
                n = new Integer(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = new Integer(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        n3 = new Integer(stringTokenizer.nextToken());
                    }
                }
            } else {
                throw new Exception("PopupNavigator.strToColor() Bad color formatting.");
            }
            if (n2 == null) {
                color = new Color(n);
            } else {
                if (n3 == null) {
                    throw new Exception("PopupNavigator.strToColor() Bad color formatting - blue is missing.");
                }
                color = new Color(n, n2, n3);
            }
        }
        return color;
    }

    private boolean strToBoolean(String string) {
        return string.equalsIgnoreCase("TRUE");
    }

    private Font constructFont(String[] stringArray, int n) {
        String string = "Dialog";
        int n2 = 0;
        int n3 = 12;
        if (stringArray != null) {
            if (stringArray[n] != null) {
                string = stringArray[n];
            }
            if (stringArray[n + 1] != null) {
                n2 = this.strToFontStyle(stringArray[n + 1]);
            }
            if (stringArray[n + 2] != null) {
                n3 = new Integer(stringArray[n + 2]);
            }
        }
        return new Font(string, n2, n3);
    }

    private String formatErrorLabel(String string, String string2, String string3, String string4) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string == null || string.length() == 0 ? "" : String.valueOf(string).concat(String.valueOf(" "))).concat(String.valueOf(string2 == null || string2.length() == 0 ? "" : String.valueOf(string2).concat(String.valueOf(" "))))).concat(String.valueOf("<PARAM NAME=\""))).concat(String.valueOf(string3 == null ? "null" : string3))).concat(String.valueOf("\" VALUE=\""))).concat(String.valueOf(string4 == null ? "null" : string4))).concat(String.valueOf("\">"));
    }

    private void selectItem(MenuItem menuItem, boolean bl) {
        if (menuItem instanceof PopupNavigatorMenuItem) {
            PopupNavigatorMenuItem popupNavigatorMenuItem = (PopupNavigatorMenuItem)menuItem;
            popupNavigatorMenuItem.setFont(new Font(this.selectionFontName != null ? this.selectionFontName : popupNavigatorMenuItem.fontName, this.selectionFontStyle != null ? this.strToFontStyle(this.selectionFontStyle) : popupNavigatorMenuItem.fontStyle.intValue(), this.selectionFontSize != null ? new Integer(this.selectionFontSize).intValue() : popupNavigatorMenuItem.fontSize.intValue()));
        } else if (menuItem instanceof PopupNavigatorMenu) {
            PopupNavigatorMenu popupNavigatorMenu = (PopupNavigatorMenu)menuItem;
            popupNavigatorMenu.setFont(new Font(this.selectionFontName != null ? this.selectionFontName : popupNavigatorMenu.fontName, this.selectionFontStyle != null ? this.strToFontStyle(this.selectionFontStyle) : popupNavigatorMenu.fontStyle.intValue(), this.selectionFontSize != null ? new Integer(this.selectionFontSize).intValue() : popupNavigatorMenu.fontSize.intValue()));
        }
        if (bl && this.selectionMode.equalsIgnoreCase(smRecursive) && menuItem.getParent() != null && menuItem.getParent() instanceof PopupNavigatorMenu) {
            this.selectItem((PopupNavigatorMenu)menuItem.getParent(), true);
        }
    }

    private void deselectItem(MenuItem menuItem, boolean bl) {
        if (menuItem instanceof PopupNavigatorMenuItem) {
            PopupNavigatorMenuItem popupNavigatorMenuItem = (PopupNavigatorMenuItem)menuItem;
            popupNavigatorMenuItem.setFont(new Font(popupNavigatorMenuItem.fontName, (int)popupNavigatorMenuItem.fontStyle, popupNavigatorMenuItem.fontSize));
        } else if (menuItem instanceof PopupNavigatorMenu) {
            PopupNavigatorMenu popupNavigatorMenu = (PopupNavigatorMenu)menuItem;
            popupNavigatorMenu.setFont(new Font(popupNavigatorMenu.fontName, (int)popupNavigatorMenu.fontStyle, popupNavigatorMenu.fontSize));
        }
        if (bl && this.selectionMode.equalsIgnoreCase(smRecursive) && menuItem.getParent() != null && menuItem.getParent() instanceof PopupNavigatorMenu) {
            this.deselectItem((PopupNavigatorMenu)menuItem.getParent(), true);
        }
    }

    private int loadMenu(Menu menu, int n) {
        String string;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.paramCoord[i]);
            if (i + 1 >= n) continue;
            stringBuffer.append(this.delimiterChar);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(this.delimiterChar);
        }
        this.paramCoord[n] = 0;
        do {
            String[] stringArray;
            String string2;
            if ((string = this.getParameter((string2 = String.valueOf(stringBuffer.toString()).concat(String.valueOf(this.paramCoord[n]))).toString(), null)) == null) continue;
            if (n2 == 0) {
                n2 = 1;
            }
            boolean bl = false;
            try {
                stringArray = this.decodeParamValue(string, null);
            }
            catch (Exception exception) {
                stringArray = new String[9];
                stringArray[0] = exception.toString();
                bl = true;
            }
            PopupNavigatorMenu popupNavigatorMenu = new PopupNavigatorMenu(string);
            int n3 = this.loadMenu(popupNavigatorMenu, n + 1);
            if (n3 > 0) {
                try {
                    popupNavigatorMenu.fontName = stringArray[1] != null ? stringArray[1] : this.defaultFontName;
                    popupNavigatorMenu.fontStyle = new Integer(this.strToFontStyle(stringArray[2] != null ? stringArray[2] : this.defaultFontStyle));
                    popupNavigatorMenu.fontSize = new Integer(stringArray[3] != null ? stringArray[3] : this.defaultFontSize);
                    if (n3 == 2) {
                        this.selectItem(popupNavigatorMenu, false);
                        n2 = n3;
                    } else {
                        this.deselectItem(popupNavigatorMenu, false);
                    }
                }
                catch (Exception exception) {
                    stringArray = new String[9];
                    stringArray[0] = exception.toString();
                }
                popupNavigatorMenu.setLabel(stringArray[0]);
                menu.add(popupNavigatorMenu);
            } else {
                PopupNavigatorMenuItem popupNavigatorMenuItem = new PopupNavigatorMenuItem(string);
                try {
                    if (stringArray[0] == null || !stringArray[0].equals("-")) {
                        if (stringArray[1] == null) {
                            if (!bl) {
                                if (this.missingURL.equalsIgnoreCase("ERROR")) {
                                    stringArray[0] = this.formatErrorLabel(null, "MISSING URL", string2.toString(), string);
                                    bl = true;
                                } else if (this.missingURL.equalsIgnoreCase("DISABLE")) {
                                    popupNavigatorMenuItem.setEnabled(false);
                                }
                            }
                        } else {
                            if (this.isCurrentDomain(stringArray[1])) {
                                popupNavigatorMenuItem.url = this.encodeURL(stringArray[1]);
                                if (popupNavigatorMenuItem.url == null && !bl) {
                                    stringArray[0] = this.formatErrorLabel(null, "MALFORMED URL", string2.toString(), string);
                                    bl = true;
                                }
                            } else {
                                popupNavigatorMenuItem.url_string = stringArray[1];
                            }
                            popupNavigatorMenuItem.frame = stringArray[2] == null ? this.defaultFrame : stringArray[2];
                        }
                        if (stringArray[0] == null) {
                            stringArray[0] = stringArray[1];
                        }
                    }
                    popupNavigatorMenuItem.fontName = stringArray[3] != null ? stringArray[3] : this.defaultFontName;
                    popupNavigatorMenuItem.fontStyle = new Integer(this.strToFontStyle(stringArray[4] != null ? stringArray[4] : this.defaultFontStyle));
                    popupNavigatorMenuItem.fontSize = new Integer(stringArray[5] != null ? stringArray[5] : this.defaultFontSize);
                    if ((this.selectionMode.equalsIgnoreCase(smRecursive) || this.selectionMode.equalsIgnoreCase(smItem)) && popupNavigatorMenuItem.url != null && popupNavigatorMenuItem.url.equals(this.getDocumentBase())) {
                        this.selectItem(popupNavigatorMenuItem, false);
                        if (this.selectionMode.equalsIgnoreCase(smRecursive)) {
                            n2 = 2;
                        }
                    } else {
                        this.deselectItem(popupNavigatorMenuItem, false);
                    }
                }
                catch (Exception exception) {
                    stringArray = new String[9];
                    stringArray[0] = exception.toString();
                    bl = true;
                }
                popupNavigatorMenuItem.setLabel(stringArray[0]);
                if (bl) {
                    popupNavigatorMenuItem.setEnabled(false);
                }
                menu.add(popupNavigatorMenuItem);
            }
            int n4 = n;
            this.paramCoord[n4] = (short)(this.paramCoord[n4] + 1);
        } while (string != null);
        return n2;
    }

    public void init() {
        try {
            this.jbInit();
            this.delimiterChar = this.getParameter("DelimiterChar", String.valueOf("").concat(String.valueOf(this.delimiterChar))).charAt(0);
            this.escapeChar = this.getParameter("EscapeChar", String.valueOf("").concat(String.valueOf(this.escapeChar))).charAt(0);
            this.URLBase = this.getParameter("URLBase", this.URLBase);
            this.defaultFontName = this.getParameter("DefaultFontName", this.defaultFontName);
            this.defaultFontStyle = this.getParameter("DefaultFontStyle", this.defaultFontStyle);
            this.defaultFontSize = this.getParameter("DefaultFontSize", this.defaultFontSize);
            this.defaultForegroundColor = this.getParameter("DefaultForegroundColor", this.defaultForegroundColor);
            this.defaultFrame = this.getParameter("DefaultFrame");
            String[] stringArray = this.decodeParamValue(this.getParameter("Label", ""), new String[]{null, this.defaultFontName, this.defaultFontStyle, this.defaultFontSize, this.defaultForegroundColor, this.defaultBackgroundColor});
            if (stringArray[0] == null) {
                stringArray[0] = this.getParameter("Label", null) == null ? "Navigate" : "";
            }
            this.labelText = stringArray[0];
            this.labelFont = this.constructFont(stringArray, 1);
            this.labelForeground = this.strToColor(stringArray[4]);
            this.labelBackground = this.strToColor(stringArray[5]);
            stringArray = this.decodeParamValue(this.getParameter("MouseoverLabel", ""), stringArray);
            this.mouseoverLabelText = stringArray[0];
            this.mouseoverLabelFont = this.constructFont(stringArray, 1);
            this.mouseoverLabelForeground = this.strToColor(stringArray[4]);
            this.mouseoverLabelBackground = this.strToColor(stringArray[5]);
            stringArray = this.decodeParamValue(this.getParameter("ClickLabel", ""), stringArray);
            this.clickLabelText = stringArray[0];
            this.clickLabelFont = this.constructFont(stringArray, 1);
            this.clickLabelForeground = this.strToColor(stringArray[4]);
            this.clickLabelBackground = this.strToColor(stringArray[5]);
            stringArray = this.decodeParamValue(this.getParameter("ButtonStyle", ""), new String[]{this.buttonStyle, this.buttonHover});
            this.buttonStyle = stringArray[0];
            this.buttonHover = stringArray[1];
            stringArray = this.decodeParamValue(this.getParameter("Selection", ""), new String[]{this.selectionMode, this.selectionFontName, this.selectionFontStyle, this.selectionFontSize});
            this.selectionMode = stringArray[0];
            this.selectionFontName = stringArray[1];
            this.selectionFontStyle = stringArray[2];
            this.selectionFontSize = stringArray[3];
            this.menuActivation = this.getParameter("MenuActivation", this.menuActivation);
            this.statusText = this.getParameter("StatusText", this.statusText);
            this.menuPosition = this.getParameter("MenuPosition", this.menuPosition);
            this.missingURL = this.getParameter("MissingURL", this.missingURL);
            this.buttonImage = this.getImageFromParam("Image", null);
            this.mouseoverButtonImage = this.getImageFromParam("MouseoverImage", this.buttonImage);
            this.clickButtonImage = this.getImageFromParam("ClickImage", this.mouseoverButtonImage);
            stringArray = this.decodeParamValue(this.getParameter("ImagePosition", ""), new String[]{this.buttonImagePosition, this.buttonImagePositionX, this.buttonImagePositionY});
            this.buttonImagePosition = stringArray[0];
            this.buttonImagePositionX = stringArray[1];
            this.buttonImagePositionY = stringArray[2];
            stringArray = this.decodeParamValue(this.getParameter("MouseoverImagePosition", ""), stringArray);
            this.mouseoverButtonImagePosition = stringArray[0];
            this.mouseoverButtonImagePositionX = stringArray[1];
            this.mouseoverButtonImagePositionY = stringArray[2];
            stringArray = this.decodeParamValue(this.getParameter("ClickImagePosition", ""), stringArray);
            this.clickButtonImagePosition = stringArray[0];
            this.clickButtonImagePositionX = stringArray[1];
            this.clickButtonImagePositionY = stringArray[2];
            this.loadMenu(this.popupMenu, 0);
            this.enableEvents(16L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridLayout1);
        this.add(this.popupMenu);
    }

    public void showPopupMenu() {
        int n;
        int n2;
        if (this.menuPosition.equalsIgnoreCase(bipRight)) {
            n2 = this.getBounds().width;
            n = 0;
        } else {
            n2 = 0;
            n = this.getBounds().height;
        }
        this.popupMenu.show(this, n2, n);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof PopupNavigatorMenuItem) {
            PopupNavigatorMenuItem popupNavigatorMenuItem = (PopupNavigatorMenuItem)event.target;
            switch (event.id) {
                case 1001: {
                    this.navigate(popupNavigatorMenuItem);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 504: {
                this.mouseIn = true;
                if (this.statusText != null) {
                    this.showStatus(this.statusText);
                }
                if (this.menuActivation.equalsIgnoreCase("MOUSEOVER")) {
                    this.showPopupMenu();
                }
                this.repaint();
                break;
            }
            case 505: {
                if (this.statusText != null) {
                    this.showStatus("");
                }
                this.mouseIn = false;
                this.repaint();
                break;
            }
            case 501: {
                this.mouseDown = true;
                this.repaint();
                break;
            }
            case 502: {
                this.mouseDown = false;
                if (mouseEvent.getX() >= this.getBounds().x && mouseEvent.getY() >= this.getBounds().y && mouseEvent.getX() <= this.getBounds().x + this.getBounds().width && mouseEvent.getY() <= this.getBounds().y + this.getBounds().height) {
                    this.showPopupMenu();
                } else {
                    this.mouseIn = false;
                }
                this.repaint();
                break;
            }
        }
    }

    public String getAppletInfo() {
        return "PopupNavigatorApplet by Branko Dimitrijevic";
    }

    private void navigate(PopupNavigatorMenuItem popupNavigatorMenuItem) {
        if (this.selectionMode.equalsIgnoreCase(smRecursive)) {
            if (this.oldSelection != null) {
                this.deselectItem(this.oldSelection, true);
            }
            this.oldSelection = popupNavigatorMenuItem;
            this.selectItem(popupNavigatorMenuItem, true);
        } else if (this.selectionMode.equalsIgnoreCase(smItem)) {
            if (this.oldSelection != null) {
                this.deselectItem(this.oldSelection, false);
            }
            this.oldSelection = popupNavigatorMenuItem;
            this.selectItem(popupNavigatorMenuItem, false);
        }
        if (popupNavigatorMenuItem.url == null) {
            popupNavigatorMenuItem.url = this.encodeURL(popupNavigatorMenuItem.url_string);
        }
        if (popupNavigatorMenuItem.frame == null) {
            this.getAppletContext().showDocument(popupNavigatorMenuItem.url);
        } else {
            this.getAppletContext().showDocument(popupNavigatorMenuItem.url, popupNavigatorMenuItem.frame);
        }
    }

    private void paintLabelAndImage(Graphics graphics, Color color, Color color2, Font font, String string, Image image, String string2, String string3, String string4) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        int n3 = string == null ? 0 : fontMetrics.stringWidth(string);
        int n4 = (n - n3) / 2;
        int n5 = (n2 - fontMetrics.getDescent() + fontMetrics.getAscent()) / 2;
        if (image != null) {
            int n6 = image.getWidth(this);
            int n7 = image.getHeight(this);
            if (n6 > 0 && n7 > 0) {
                int n8;
                int n9;
                if (string2.equalsIgnoreCase(bipAbsolute)) {
                    n9 = new Integer(string3);
                    if (n9 < 0) {
                        n9 = n + n9 - n6;
                    }
                    if ((n8 = new Integer(string4).intValue()) < 0) {
                        n8 = n2 + n8 - n7;
                    }
                } else if (string2.equalsIgnoreCase(bipCenter)) {
                    n9 = (n - n6) / 2;
                    n8 = (n2 - n7) / 2;
                } else if (string2.equalsIgnoreCase(bipLeft) || string2.equalsIgnoreCase(bipRight)) {
                    int n10 = new Integer(string3);
                    n9 = string2.equalsIgnoreCase(bipLeft) ? (n4 += n10 / 2) - n10 - n6 : (n4 -= n10 / 2) + n3 + n10;
                    n8 = (n2 - n7) / 2;
                } else if (string2.equalsIgnoreCase(bipTop) || string2.equalsIgnoreCase(bipBottom)) {
                    int n11 = new Integer(string3);
                    n8 = string2.equalsIgnoreCase(bipTop) ? (n5 += n11 / 2) - fontMetrics.getAscent() - n11 - n7 : (n5 -= n11 / 2) + fontMetrics.getDescent() + n11;
                    n9 = (n - n6) / 2;
                } else {
                    n9 = 0;
                    n8 = 0;
                }
                graphics.drawImage(image, n9, n8, this);
            }
        }
        if (string != null) {
            graphics.setColor(color2);
            graphics.drawString(string, n4, n5);
        }
    }

    private void paint3dRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, boolean bl) {
        if (!bl) {
            Color color3 = color;
            color = color2;
            color2 = color3;
        }
        graphics.setColor(color);
        graphics.drawLine(n, n2, n3, n2);
        graphics.drawLine(n, n2, n, n4);
        graphics.setColor(color2);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n, n4, n3, n4);
    }

    private void paintThinBorder(Graphics graphics, boolean bl) {
        this.paint3dRect(graphics, 0, 0, this.getBounds().width - 1, this.getBounds().height - 1, Color.white, Color.gray, bl);
    }

    private void paintNormalBorder(Graphics graphics, boolean bl) {
        this.paint3dRect(graphics, 1, 1, this.getBounds().width - 2, this.getBounds().height - 2, Color.lightGray, Color.gray, bl);
        this.paint3dRect(graphics, 0, 0, this.getBounds().width - 1, this.getBounds().height - 1, Color.white, Color.darkGray, bl);
    }

    private void paintThickBorder(Graphics graphics, boolean bl) {
        this.paint3dRect(graphics, 2, 2, this.getBounds().width - 3, this.getBounds().height - 3, Color.lightGray, Color.gray, bl);
        this.paint3dRect(graphics, 1, 1, this.getBounds().width - 2, this.getBounds().height - 2, Color.white, Color.darkGray, bl);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
    }

    private void paintButtonBorder(Graphics graphics, boolean bl) {
        if (this.buttonStyle.equalsIgnoreCase(bsSemiflat)) {
            this.paintThinBorder(graphics, bl);
        } else if (this.buttonStyle.equalsIgnoreCase(bsNormal)) {
            this.paintNormalBorder(graphics, bl);
        }
    }

    private void paintHoverBorder(Graphics graphics, boolean bl) {
        if (this.buttonStyle.equalsIgnoreCase(bsFlat)) {
            this.paintThinBorder(graphics, bl);
        } else if (this.buttonStyle.equalsIgnoreCase(bsSemiflat)) {
            this.paintNormalBorder(graphics, bl);
        } else if (this.buttonStyle.equalsIgnoreCase(bsNormal)) {
            this.paintThickBorder(graphics, bl);
        }
    }

    public void paint(Graphics graphics) {
        if (this.mouseDown) {
            this.paintLabelAndImage(graphics, this.clickLabelBackground, this.clickLabelForeground, this.clickLabelFont, this.clickLabelText, this.clickButtonImage, this.clickButtonImagePosition, this.clickButtonImagePositionX, this.clickButtonImagePositionY);
            if (this.buttonHover.equalsIgnoreCase(bhHover)) {
                this.paintHoverBorder(graphics, false);
            } else {
                this.paintButtonBorder(graphics, false);
            }
        } else if (this.mouseIn) {
            this.paintLabelAndImage(graphics, this.mouseoverLabelBackground, this.mouseoverLabelForeground, this.mouseoverLabelFont, this.mouseoverLabelText, this.mouseoverButtonImage, this.mouseoverButtonImagePosition, this.mouseoverButtonImagePositionX, this.mouseoverButtonImagePositionY);
            if (this.buttonHover.equalsIgnoreCase(bhHover)) {
                this.paintHoverBorder(graphics, true);
            } else {
                this.paintButtonBorder(graphics, true);
            }
        } else {
            this.paintLabelAndImage(graphics, this.labelBackground, this.labelForeground, this.labelFont, this.labelText, this.buttonImage, this.buttonImagePosition, this.buttonImagePositionX, this.buttonImagePositionY);
            this.paintButtonBorder(graphics, true);
        }
    }
}

